﻿using System;
using System.Security.Cryptography;

namespace gov.va.med.vbecs.Common
{
    #region Header
    ///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
    ///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
    ///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
    ///<Developers>
    ///	<Developer>Carrie Van Stedum</Developer>
    ///</Developers>
    ///<SiteName>Hines OIFO</SiteName>
    ///<CreationDate>12/12/2014 CR 3518</CreationDate>
    ///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
    /// <summary>
    /// Enum that's used to update the LastUpdateFunctionId column in the tables
    /// </summary>
    /// 
    #endregion
 public class CryptoRandom : RandomNumberGenerator
 {
 
     private static RandomNumberGenerator r;
 
     ///<summary>
     /// Creates an instance of the default implementation of a cryptographic random number generator that can be used to generate random data.
     ///</summary>
     public CryptoRandom()
      { 
            r = RandomNumberGenerator.Create();
      }
 
      ///<summary>
      /// Fills the elements of a specified array of bytes with random numbers.
      ///</summary>
      ///<param name="buffer">An array of bytes to contain random numbers.</param>
      public override void GetBytes(byte[] buffer)
      {
            r.GetBytes(buffer);
      }
 
      ///<summary>
      /// Returns a random number between 0.0 and 1.0.
      ///</summary>
      public double NextDouble()
      {
            byte[] b = new byte[4];
            r.GetBytes(b);
            return (double)BitConverter.ToUInt32(b, 0) / UInt32.MaxValue;
      }
 
      ///<summary>
      /// Returns a random number within the specified range.
      ///</summary>
      /// <param name="minValue">The inclusive lower bound of the random number returned.</param>
      ///<param name="maxValue">The exclusive upper bound of the random number returned. maxValue must be greater than or equal to minValue.</param>
      public int Next(int minValue, int maxValue)
      {
            return (int)Math.Round(NextDouble() * (maxValue - minValue - 1)) + minValue;
      }
 
      ///<summary>
      /// Returns a nonnegative random number.
      ///</summary>
      public int Next()
      {
            return Next(0, Int32.MaxValue);
      }
 
      ///<summary>
      /// Returns a nonnegative random number less than the specified maximum
      ///</summary>
      ///<param name= "maxValue">The inclusive upper bound of the random number returned. maxValue must be greater than or equal 0</param>
      public int Next(int maxValue)
      {
            return Next(0, maxValue);
      }
    }

}
